#include <iostream>
#include <cstdlib> //random number information from metashell.com
#include <time.h>
#include <fstream> //Text file i/o information from cprogramming.com
#include <conio.h> //getche() information from programmersheaven.com
#include "color.h" //Header from Supersloth.net, retrieved from http://www.dreamincode.net/forums/index.php?showtopic=12347

int robotx[400], roboty[400], robotcheck[400], humanx = 10, humany = 10, humancheck = 1, robotnum = 0, robotskilled = 0, scorecounter;
char robotgrid[20][20];
using namespace std;

void randomizer(void) //This determines robot location at the start of each level
        {
       	int jack;
       	for (jack = 0; jack < 400; jack++)
		{
        		robotcheck[jack] = 1; //Sets all robots in the current level to "alive"
        }

        robotnum = robotnum + 10; // Adds 10 robots each level
        for(int counter3 = 0;counter3<robotnum;counter3++)
		{
	        robotx[counter3] = int((double(rand())/RAND_MAX)*20); //The formula to determine the random robot locations
	        roboty[counter3] = int((double(rand())/RAND_MAX)*20);
  		}
  	}

int move(void) //This function modifies the actual board based on variable data generated by movedetermine()
	{
	for (int countergrid1=0; countergrid1<20; countergrid1++) //These nested loops reset the board to all empty.
	    {
	    for (int countergrid2=0; countergrid2<20; countergrid2++)
	        robotgrid[countergrid1][countergrid2]='.';
	    }

	for (int counter=0; counter<robotnum; counter++)  //This loop places the robots and junk piles
            {
            if (robotcheck[counter]==1)
            	robotgrid[robotx[counter]][roboty[counter]]='+';
            else
                robotgrid[robotx[counter]][roboty[counter]]='*';
            }
	robotgrid[humanx][humany]='@'; //Finally, it's time to place the human.
	return 0;
	}

int movedetermine(void) //This function is the main body of the Robot AI
	{
	int counter;

for(counter = 0; counter < robotnum; counter++) //This loop runs for every robot on the board
        {
	if (robotcheck[counter]==1) //This determines whether the robot is still alive... Junk Piles don't move!
		{
		if (robotx[counter] > humanx) //Determines the X movement
			robotx[counter]--;
		else
		{
	        if (robotx[counter] < humanx)
				robotx[counter]++;
	    }
	    if (roboty[counter] > humany) //Determines the Y movement
			roboty[counter]--;
	    else
		{
			if (roboty[counter] < humany)
				roboty[counter]++;
        }
		}
	}

}

int check(void) //This function makes sure rules are obeyed: the human can't leave the board, the robots must crash into each other, etc.
{
	for (int counter1 = 0; counter1 < robotnum; counter1++) //This is the first robot
    {
		for (int counter2 = 0; counter2 < robotnum; counter2++) //This is the second
        {
			if (robotx[counter1] == robotx[counter2] && roboty[counter1] == roboty[counter2] && counter1 != counter2) //This determines whether they crashed
            {
				robotcheck[counter1]=0; //If they did, set their life to "zero"
				robotcheck[counter2]=0;
				robotgrid[robotx[counter1]][roboty[counter1]]='*'; //And put a junk pile where they were.
            }
        }
		if (humanx < 0) //Just making sure the human can't escape the grid
			humanx = 0;
		if (humany < 0)
			humany = 0;
		if (humanx > 19)
			humanx = 19;
		if (humany > 19)
			humany = 19;
		if (robotx[counter1] == humanx && roboty[counter1] == humany)
			humancheck = 0;
    }
}

int main(void)
{

	int counter3, counter4, robotcount;
	char movement;
  
	system("cls");
	cout << " + ROBOTS! @ " << endl << "A game in c++ by: Michael Meyer, Kevin Li, Jack Feser." << endl; //Title screen
	cout << "Press ? for controls or rules help." << endl;
	system("pause");

	srand(time(NULL)); //Seeding the random number generator


	while (humancheck==1) //This loop runs while the game is in progress
{
	randomizer(); //Determines random robot locations
	robotcount = robotnum; //Resets variables
	humanx = 10;
	humany = 10;
	while (robotcount > 0 && humancheck==1) //This loop should run while some robots and the human are alive
        {
		move(); //Refreshes the board data
		bad:
		system("cls");
		cout << "LEVEL " << robotnum / 10; //Shows what level you are on
		cout << endl;
		for (counter3=0; counter3<20; counter3++) // Displays the board
		{
			cout << endl;
			for (counter4=0; counter4<20; counter4++)
            {
            if (robotgrid[counter4][counter3] == '@')
               textcolor(White,Green);
            if (robotgrid[counter4][counter3] == '+')
               textcolor(White,Red);
            if (robotgrid[counter4][counter3] == '*')
               textcolor(White,Purple);
			cout << robotgrid[counter4][counter3];
            textcolor(White,Black);
            cout << " ";
            }
        }
        
		movement=getche();
		
	switch (movement) //This is the statement which analyzes the movement direction
	{
    case '?':
         system("cls");
         cout << "Keys use vi key bindings:      Or Numpad directions:" << endl << endl << "Y K U               7 8 9" << endl << "H   L               4   6" << endl << "B J N               1 2 3" << endl << "t (or *) to teleport" << endl << endl << "Your goal in this game is to destroy all the robots on screen.  The robots' goal is to kill you.  However, they can achieve their goal quite a bit easier than you can achieve yours.  You are unarmed, so what you have to do is trick the robots into crashing into each other.  Since they will always move towards you, they're pretty easy to trick.  Good luck!" << endl << endl;
         system("pause");
         goto bad;
         break;       
           
    case '7':
	case 'y':
		humanx--;
		humany--;
		break;

    case '8':
    case 'k':
		humany--;
		break;

    case '9':
    case 'u':
		humanx++;
		humany--;
		break;

    case '4':
    case 'h':
		humanx--;
		break;

    case '6':
    case 'l':
		humanx++;
		break;

    case '1':
    case 'b':
		humanx--;
		humany++;
		break;

    case '2':
    case 'j':
		humany++;
		break;

    case '*':
    case 't':
		humanx = int((double(rand())/RAND_MAX)*20); //When you teleport, there is a similar random generator as for the robots.
		humany = int((double(rand())/RAND_MAX)*20);
		break;

    case '3':
    case 'n':
		humanx++;
		humany++;
    }

    movedetermine(); //Moves the robots
    check(); //Double checks to make sure all rules are obeyed
    robotcount = 0;
    for(int counting=0; counting<10; counting++) //Checks how many robots are left
		{
		if(robotcheck[counting]==1)
		robotcount++; 
		}
    }
}
  int countess = 0;
  system("cls");
  cout << "Oops, a robot got you!  Game over." << endl; // End of game message
  for(int counting=0; counting<10; counting++)
		{
		if(robotcheck[counting]==0)
		countess++;
		}
  cout << "You survived until level " << robotnum / 10  << "!" << endl;
  for (scorecounter = 1; scorecounter < robotnum / 10; scorecounter++)
      robotskilled = scorecounter * 10 + robotskilled;
  for (scorecounter = 0; scorecounter < robotnum; scorecounter++)
      {
      if (robotcheck[scorecounter] == 0)
         robotskilled++;
      }
  cout << "Your score was: " << robotskilled << ".  Congratulations!" << endl;
  
  ofstream fout("highscores.txt", ios::app); //Text file i/o for list of high scores
  fout << robotskilled << "\n";
  fout.close();
  
  cout << "Your score history:" << endl;
  
  ifstream myfile("highscores.txt");
  
  int line, line2;
  
  while (! myfile.eof() )
    {
    myfile >> line;
    if ( ! myfile.eof() )
       cout << line << endl;
    }
  
  myfile.close();

  system("pause");
  return 0;
}

 	  	 
